<?php
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("admin_config_settings_change_commit", "verify_id_thread");
$plugins->add_hook("global_end", "force_view_thread");

function forcethread_info()
{
	return array(
		"name"			=> "هاك اجبار العضو علي مشاهدة موضوع ",
		"description"	=> "يعمل علي اجبار العضو علي مشاهدة معين تقوم بتحديده ليستطيع التصفح.",
		"website"		=> "http://www.mybb-es.com/",
		"author"		=> "Edson Ordaz",
		"authorsite"	=> "mailto:nicedo_eeos@hotmail.com",
		"version"		=> "1.0",
		"compatibility" => "16*",
		"guid"			=> "8f310897e9700d17152872839f1f41f1"
	);
}

function forcethread_activate()
{
	global $db, $cache;
	if(!$db->field_exists("forcethread", "users"))  
	{
		$db->add_column("users", "forcethread", "int(10) unsigned NOT NULL default '0'"); 
	}
	$update_cache = array(
		"tid" => '0'
	);
	$cache->update("forcethread", $update_cache);
	
	$setting_group = array(
		'name' => "forcethread",
		'title' => "هاك اجبار العضو لمشاهدة موضوع",
		'description' => "اعدادات الهاك",
		'disporder' => 1,
		'isdefault' => 0,
		);
	$db->insert_query('settinggroups', $setting_group);
	$group = $db->insert_id();
	
	$settings = array(
		'forcethread_active' => array("تفعيل", "هل تريد تفعيل الهاك؟", 'yesno', '0'),
		'forcethread_tid' => array("رقم الموضوع", "ادخل ايدي الموضوع المراد اجبار العضو علي مشاهدته", 'text', '0'),
		'forcethread_message' => array("رسالة التنبيه", "هنا الرسالة التي ستظهر للعضو ويرجي الانتهاء للاكواد في حالة التعديل", 'textarea', 'مرحبا {user} لاستكمال تصفح الموقع يرجي مشاهدة هذا الموضوع اولا <a href="{url}" />{subject}</a>'),
		);

	$i = 1;
	foreach($settings as $name => $sinfo)
	{
		$insert_array = array(
			'name' => $name,
			'title' => $db->escape_string($sinfo[0]),
			'description' => $db->escape_string($sinfo[1]),
			'optionscode' => $db->escape_string($sinfo[2]),
			'value' => $db->escape_string($sinfo[3]),
			'gid' => $group,
			'disporder' => $i,
			'isdefault' => 0,
			);
		$db->insert_query('settings', $insert_array);
		$i++;
	}
	rebuild_settings();
}

function forcethread_deactivate()
{
	global $db, $cache;
	if($db->field_exists("forcethread", "users"))  
	{
		$db->drop_column("users", "forcethread");
	}
    $db->delete_query("datacache", "title='forcethread'");
	
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='forcethread'");
	$db->delete_query("settings","name LIKE 'forcethread_%'");
}

function verify_id_thread()
{
	global $mybb, $lang, $db, $cache;
	$settings = &$mybb->input['upsetting'];
	if(isset($settings['forcethread_active']) && $settings['forcethread_tid'])
	{
		$thread = get_thread(intval($settings['forcethread_tid']));
		if(!$thread['tid'])
		{ 
			$lang->success_settings_updated = "The thread you selected does not exist";
			$db->update_query("settings", array('value' => '0'), "name='forcethread_tid'");
			$db->update_query("settings", array('value' => '0'), "name='forcethread_active'");
		}
		else
		{
			$db->update_query("users", array('forcethread' => '1'));
			$db->delete_query("datacache", "title='forcethread'");
			$cache->update("forcethread", array("tid" => $thread['tid']));
		}
	}
}

function force_view_thread()
{
	global $mybb, $db, $cache, $plugins;
	if($mybb->user['forcethread'] == 1 && intval($mybb->settings['forcethread_active']) == 1)
	{
		if(THIS_SCRIPT != "showthread.php")
		{		
			$thread = get_thread(intval($mybb->settings['forcethread_tid']));
			$mybb->settings['forcethread_message'] = preg_replace("!\{subject\}!Us", $thread['subject'], $mybb->settings['forcethread_message']);
			$mybb->settings['forcethread_message'] = preg_replace("!\{url\}!Us", "showthread.php?tid=".$thread['tid'], $mybb->settings['forcethread_message']);
			$mybb->settings['forcethread_message'] = preg_replace("!\{user\}!Us", $mybb->user['username'], $mybb->settings['forcethread_message']);
			error($mybb->settings['forcethread_message'], "قوانين المنتدي");
		}
		else
		{
			$plugins->add_hook("showthread_start", "verify_tid_force_thread");
			function verify_tid_force_thread()
			{
				global $tid, $mybb, $db;
				$thread = get_thread(intval($mybb->settings['forcethread_tid']));
				if($tid != intval($mybb->settings['forcethread_tid']))
				{
					$mybb->settings['forcethread_message'] = preg_replace("!\{subject\}!Us", $thread['subject'], $mybb->settings['forcethread_message']);
					$mybb->settings['forcethread_message'] = preg_replace("!\{url\}!Us", "showthread.php?tid=".$thread['tid'], $mybb->settings['forcethread_message']);
					$mybb->settings['forcethread_message'] = preg_replace("!\{user\}!Us", $mybb->user['username'], $mybb->settings['forcethread_message']);
					error($mybb->settings['forcethread_message'], "قوانين الموقع");
				}
				else
				{
					$db->update_query("users", array('forcethread' => '0'), "uid='".$mybb->user['uid']."'");
				}
			}
		}
	}
}

?>